//Listing 18.7. Przykad generowania wyjtku z obiektem zdefiniowanej klasy zamiast wartoci wbudowanego typu
#include <iostream>
#include <cfloat>
using namespace std;

class MSG {
       static char* data []; // wewntrzne dane statyczne
public:
       static char* msg(int n) // publiczna metoda statyczna
       { if (n<1 || n > 5) // sprawd poprawno indeksu
            return data[0];
         else
            return data[n]; } // zwr poprawny acuch znakowy
} ;

char* MSG::data [] = { "\nNiepoprawny argument funkcji msg()\n",
"\nZerowy mianownik nie jest dozwolony \n\n", // tablica tekstw
"\nMianownik ujemny: ",
"Podaj licznik oraz nieujemny\n",
"mianownik (dowolna litera aby zakoczy): ",
"Warto uamka: "
} ;

class ZeroDenom {
      char *msg; // dane ktra zostan przekazane do procedury obsugi bdu
public:
      ZeroDenom () // jest wywoywana przez instrukcj throw
      { msg = MSG::msg(1); }
      void print () const // jest wywoywana wewntrz bloku catch
      { cout << msg; }
} ;

class NegativeDenom {
      long val; // prywatne dane przechowujce informacje o wyjtku
      char* msg;
public:
      NegativeDenom(long value) // konstruktor konwertujcy
            : val(value), msg(MSG::msg(2)) { }
      char* getMsg() const
            { return msg; }
      long getVal() const // publiczne metody suce w celu uzyskania dostpu do danych
            { return val; }
} ;

inline void inverse(long value, double& answer)
      throw (ZeroDenom, NegativeDenom)
{ answer = (value) ? 1.0/value : DBL_MAX;
  if (answer==DBL_MAX)
      throw ZeroDenom();
  if (value < 0)
      throw NegativeDenom(value); }

inline void fraction (long numer, long denom, double& result)
      throw (ZeroDenom, NegativeDenom)
{ inverse(denom, result); // result = 1.0 / denom
  result = numer * result; } // result = numer/denom

int main()
{
  while (true)
  { long numer, denom; double ans; // licznik/mianownik
    cout << MSG::msg(3) << MSG::msg(4); // popro o dane uytkownika
    if ((cin >> numer >> denom) == 0) break; // wprowad dane
    try {
        fraction(numer,denom,ans); // oblicz uamek
        cout << MSG::msg(5) << ans <<"\n\n"; } // poprawna odpowied
    catch (const ZeroDenom& zd) // mianownik zerowy
    { zd.print(); }
    catch (const NegativeDenom &nd) // warto ujemna
    { cout << nd.getMsg() << nd.getVal() << "\n\n"; }
  }
return 0;
}
